"/****** HIRP.S = HOST INTERRUPT SVC (MTS100) = REL 0.0  , JUL 79 *************
"
"               CHANGED  79-JUL-17    13:15
"
"       FOR USE WITH FPS-100 SUPERVISOR
"         JOSEPH E. RAMUS        MAY 79
"
"       TAB STOP SETTINGS FOR EDITOR:    9   33  60
"
"         SPAD REGISTER NAMES DEFINED IN SYSDEF
"           R0 R1 R2 R3 R4 R5 R6 R7
"
"         INDEXES FOR DATA PAD X DEFINED IN SYSDEF
"           X0 X1 X2 X3
"
"       APMSG    IS MESSAGE BUFFER FOR SEND TO APEX OR FUNC TASK
"       EXAPEX   IS APEX MESSAGE EXCHANGE
"       EXFUNC   IS FUNCTION MESSAGE EXCHANGE
"       FSPAD    IS STORAGE FOR SPLDGO SPAD VALUES
"       VDATM    IS STORAGE FOR DATUM VALUES
"
"       EXDAT1    IS MSG EXCHANGE FOR DATUM 1
"        ---
"       EXDAT7    IS MSG EXCHANGE FOR DATUM 7
"
"       MGDAT1    IS MSG BUFFER FOR DATUM 1
"        ---
"       MGDAT7    IS MSG BUFFER FOR DATUM 7
"
$ISR 7
$TITLE  HIRP
$ENTRY  HIRP,0
$EXT SEND
$EXT WATSWR
"
"             $INSERT SYSDEF
$NOLIST
$INSERT SYSDEF
$LIST
"
"
$INSERT FHOSTC
"
"          DEFINE THE MESSAGE HEADER AND CONTENTS
"         FOR USER APEX AND FUNC INTERPRET TASKS
$DATA  APMSG (1.)  APMSG    "RT LINK
$DATA  APMSG (2.)  APMSG    "LEFT LINK
$DATA  APMSG (3.)  0        "PRIORITY
$DATA  APMSG (4.)  0         "TYPE
$DATA  APMSG (5.)  11.       "LENGTH
$DATA  APMSG (6.)  EXAPEX    "ANSKEY (APEX EXCHANGE ADDRESS)
$DATA  APMSG (7.)  0         "APEX OPTION
$DATA  APMSG (8.)  0         "SPAD COUNT
$DATA  APMSG (9.)  0         "SWR VALUE
$DATA  APMSG (10.) 0         "FUNC VALUE OR START ADDRESS
$DATA  APMSG (11.) 0         "EXTRA SPACE
"
"           DEFINE A MESSAGE EXCHANGE FOR USER APEX TASK
$DATA  EXAPEX (1)  EXAPEX       "RT LINK
$DATA  EXAPEX (2)  EXAPEX       "LEFT LINK
$DATA  EXAPEX (3)  0            "PRIORITY
$DATA  EXAPEX (4)  0            "TYPE
$DATA  EXAPEX (5)  6            "LENGTH
$DATA  EXAPEX (6)  0            "MISC
"
"       DEFINE A MESSAGE EXCHANGE FOR FUNC INTERPRETER TASK
$DATA  EXFUNC (1)  EXFUNC
$DATA  EXFUNC (2)  EXFUNC
$DATA  EXFUNC (3)  0
$DATA  EXFUNC (4)  0
$DATA  EXFUNC (5)  6
$DATA  EXFUNC (6)  0
"
"        DEFINE A MESSAGE EXCHANGE FOR DATUM 1
$DATA  EXDAT1 (1)  EXDAT1
$DATA  EXDAT1 (2)  EXDAT1
$DATA  EXDAT1 (3)  0
$DATA  EXDAT1 (4)  0
$DATA  EXDAT1 (5)  6
$DATA  EXDAT1 (6)  0
"        DEFINE A MESSAGE EXCHANGE FOR DATUM 2
$DATA  EXDAT2 (1)  EXDAT2
$DATA  EXDAT2 (2)  EXDAT2
$DATA  EXDAT2 (3)  0
$DATA  EXDAT2 (4)  0
$DATA  EXDAT2 (5)  6
$DATA  EXDAT2 (6)  0
"        DEFINE A MESSAGE EXCHANGE FOR DATUM 3
$DATA  EXDAT3 (1)  EXDAT3
$DATA  EXDAT3 (2)  EXDAT3
$DATA  EXDAT3 (3)  0
$DATA  EXDAT3 (4)  0
$DATA  EXDAT3 (5)  6
$DATA  EXDAT3 (6)  0
"        DEFINE A MESSAGE EXCHANGE FOR DATUM 4
$DATA  EXDAT4 (1)  EXDAT4
$DATA  EXDAT4 (2)  EXDAT4
$DATA  EXDAT4 (3)  0
$DATA  EXDAT4 (4)  0
$DATA  EXDAT4 (5)  6
$DATA  EXDAT4 (6)  0
"        DEFINE A MESSAGE EXCHANGE FOR DATUM 5
$DATA  EXDAT5 (1)  EXDAT5
$DATA  EXDAT5 (2)  EXDAT5
$DATA  EXDAT5 (3)  0
$DATA  EXDAT5 (4)  0
$DATA  EXDAT5 (5)  6
$DATA  EXDAT5 (6)  0
"        DEFINE A MESSAGE EXCHANGE FOR DATUM 6
$DATA  EXDAT6 (1)  EXDAT6
$DATA  EXDAT6 (2)  EXDAT6
$DATA  EXDAT6 (3)  0
$DATA  EXDAT6 (4)  0
$DATA  EXDAT6 (5)  6
$DATA  EXDAT6 (6)  0
"        DEFINE A MESSAGE EXCHANGE FOR DATUM 7
$DATA  EXDAT7 (1)  EXDAT7
$DATA  EXDAT7 (2)  EXDAT7
$DATA  EXDAT7 (3)  0
$DATA  EXDAT7 (4)  0
$DATA  EXDAT7 (5)  6
$DATA  EXDAT7 (6)  0
"       DEFINE THE MESSAGE BUFFER FOR DATUM 1
$DATA  MGDAT1 (1.)  MGDAT1    "RT LINK
$DATA  MGDAT1 (2.)  MGDAT1    "LEFT LINK
$DATA  MGDAT1 (3.)  0         "PRIORITY
$DATA  MGDAT1 (4.)  0         "TYPE
$DATA  MGDAT1 (5.)  7.       "LENGTH
$DATA  MGDAT1 (6.)  EXDAT1    "ANSKEY (DATUM EXCHANGE ADDRESS)
$DATA  MGDAT1 (7.)  0         "
"       DEFINE THE MESSAGE BUFFER FOR DATUM 2
$DATA  MGDAT2 (1.)  MGDAT2    "RT LINK
$DATA  MGDAT2 (2.)  MGDAT2    "LEFT LINK
$DATA  MGDAT2 (3.)  0         "PRIORITY
$DATA  MGDAT2 (4.)  0         "TYPE
$DATA  MGDAT2 (5.)  7.       "LENGTH
$DATA  MGDAT2 (6.)  EXDAT2    "ANSKEY (DATUM EXCHANGE ADDRESS)
$DATA  MGDAT2 (7.)  0         "
"       DEFINE THE MESSAGE BUFFER FOR DATUM 3
$DATA  MGDAT3 (1.)  MGDAT3    "RT LINK
$DATA  MGDAT3 (2.)  MGDAT3    "LEFT LINK
$DATA  MGDAT3 (3.)  0         "PRIORITY
$DATA  MGDAT3 (4.)  0         "TYPE
$DATA  MGDAT3 (5.)  7.       "LENGTH
$DATA  MGDAT3 (6.)  EXDAT3    "ANSKEY (DATUM EXCHANGE ADDRESS)
$DATA  MGDAT3 (7.)  0         "
"       DEFINE THE MESSAGE BUFFER FOR DATUM 4
$DATA  MGDAT4 (1.)  MGDAT4    "RT LINK
$DATA  MGDAT4 (2.)  MGDAT4    "LEFT LINK
$DATA  MGDAT4 (3.)  0         "PRIORITY
$DATA  MGDAT4 (4.)  0         "TYPE
$DATA  MGDAT4 (5.)  7.       "LENGTH
$DATA  MGDAT4 (6.)  EXDAT4    "ANSKEY (DATUM EXCHANGE ADDRESS)
$DATA  MGDAT4 (7.)  0         "
"       DEFINE THE MESSAGE BUFFER FOR DATUM 5
$DATA  MGDAT5 (1.)  MGDAT5    "RT LINK
$DATA  MGDAT5 (2.)  MGDAT5    "LEFT LINK
$DATA  MGDAT5 (3.)  0         "PRIORITY
$DATA  MGDAT5 (4.)  0         "TYPE
$DATA  MGDAT5 (5.)  7.       "LENGTH
$DATA  MGDAT5 (6.)  EXDAT5    "ANSKEY (DATUM EXCHANGE ADDRESS)
$DATA  MGDAT5 (7.)  0         "
"       DEFINE THE MESSAGE BUFFER FOR DATUM 6
$DATA  MGDAT6 (1.)  MGDAT6    "RT LINK
$DATA  MGDAT6 (2.)  MGDAT6    "LEFT LINK
$DATA  MGDAT6 (3.)  0         "PRIORITY
$DATA  MGDAT6 (4.)  0         "TYPE
$DATA  MGDAT6 (5.)  7.       "LENGTH
$DATA  MGDAT6 (6.)  EXDAT6    "ANSKEY (DATUM EXCHANGE ADDRESS)
$DATA  MGDAT6 (7.)  0         "
"       DEFINE THE MESSAGE BUFFER FOR DATUM 7
$DATA  MGDAT7 (1.)  MGDAT7    "RT LINK
$DATA  MGDAT7 (2.)  MGDAT7    "LEFT LINK
$DATA  MGDAT7 (3.)  0         "PRIORITY
$DATA  MGDAT7 (4.)  0         "TYPE
$DATA  MGDAT7 (5.)  7.       "LENGTH
$DATA  MGDAT7 (6.)  EXDAT7    "ANSKEY (DATUM EXCHANGE ADDRESS)
$DATA  MGDAT7 (7.)  0         "
$DATA  VDATM(1.)  0
$DATA  VDATM(2.)  0
$DATA  VDATM(3.)  0
$DATA  VDATM(4.)  0
$DATA  VDATM(5.)  0
$DATA  VDATM(6.)  0
$DATA  VDATM(7.)  0
$DATA  VDATM( 8.)  MGDAT1
$DATA  VDATM( 9.)  MGDAT2
$DATA  VDATM(10.)  MGDAT3
$DATA  VDATM(11.)  MGDAT4
$DATA  VDATM(12.)  MGDAT5
$DATA  VDATM(13.)  MGDAT6
$DATA  VDATM(14.)  MGDAT7
$DATA   VDATM(15.)  EXDAT1
$DATA   VDATM(16.)  EXDAT2
$DATA   VDATM(17.)  EXDAT3
$DATA   VDATM(18.)  EXDAT4
$DATA   VDATM(19.)  EXDAT5
$DATA   VDATM(20.)  EXDAT6
$DATA   VDATM(21.)  EXDAT7
"
"
"
"
"
"/****** HIRP = HOST INTERRUPT SERVICE ROUTINE = REL 0.0  , JUL 79 ************
"
"         HOST INTERRUPT SERVICE ROUTINE
"
"           THIS ROUTINE IS CALLED WHEN AN INTERRUPT IS
"             RECEIVED FROM THE HOST.
"
"         NOTE:  CLEAR R0 WHEN RETURNING TO RE-ENABLE THE HOST IRP.
"
HIRP:   ION                     "ENABLE INTERRUPTS
        JSR APXMT               "READ SWR
        MOV R1,R0
        BEQ HIRP5;              "GO IF NOT A DATUM VALUE
          LDMA; DB=APMSG+5        "SET MESSAGE BUFFER ADDRESS
        JMP DATUM               "WE HAVE A DATUM VALUE
HIRP5:  JSR APXMT               "GET OPTION VALUE
        MOV R1,R4;              "SAVE OPTION IN R4
          INCMA; MI<SPFN          " AND PUT IN MSG BUFFER
        JSR APXMT               "GET SPAD COUNT
        MOV R1,R3;              "SAVE COUNT IN R3
          INCMA; MI<SPFN          " AND PUT IN MSG BUFFER
        JSR APXMT               "GET SWR VALUE
        MOV R1,R5;              "SAVE SWR VALUE IN R5
          INCMA; MI<SPFN          " AND PUT IN MSG BUFFER
        JSR APXMT               "GET FUNC VALUE
        MOV R1,R1;              "FUNC VALUE
          INCMA; MI<SPFN          " AND PUT IN MSG BUFFER
"
"           SPAD R1  CONTAINS FUNCTION VALUE
"           SPAD R3  HAS SPAD COUNT
"           SPAD R4  HAS OPTION VALUE
"           SPAD R5  CONTAINS SWR VALUE
"
"             OPTION VALUES:
"           0 - UNUSED
"           1 - SPLDGO
"           2 - RUNAP
"           3 - FUNCTION INTERPRET
"
        DEC R4                  "FOR TESTING OPTION VALUE
        BEQ SPADS;             "GO IF SPLDGO
          DEC R4
        BEQ MSEND               "GO IF RUNAP
"
"                 SEND MESSAGE TO FUNCTION INTERPRETER TASK
        SETMOD;                 "SET SUPERVISOR MODE
          DPX(X1)<EXFUNC;       "MESSAGE EXCHANGE
          BR YSEND
"
"           SEND A MESSAGE TO APEX TASK
MSEND:  SETMOD;                 "SET SUPERVISOR MODE
          DPX(X1)<EXAPEX          "MESSAGE EXCHANGE
YSEND:  IOFF;                   "INTERRUPTS OFF
        DPX(X0)<APMSG           "MESSAGE FOR APEX USER TASK
        JSR SEND                "SEND MESSAGE
        CLR R0;                 "TO RE-ENABLE HOST IRP
          RETURN                  "BACK TO SUPERVISOR
"
"/****** SPADS = READ SPAD VALUES = REL 0.0  , JUL 79 *************************
"                  SPLDGO  --  READ SPAD VALUES
SPADS: MOV R3,R3               "TO TEST SPAD COUNT
       BEQ MSEND;              "GO IF SPAD COUNT IS ZERO
         LDMA; DB=FSPAD-1        "SET MEMORY ADDRESS
 "
SPAD1B: JSR  APXMT              "GET SPAD VALUE
        INCMA; MI<DPX(X1);       "WRITE SPAD VALUE IN MEMORY
          DEC R3                  "LOOP COUNTER
        BNE  SPAD1B             "NOT YET DONE
        JMP MSEND
"
"/****** DATUM = PROCESS DATUM VALUE FROM HOST = REL 0.0  , JUL 79 ************
"         R0 & R1 HAVE DATUM VALUE
"         DPX(X1) ALSO HAS DATUM VALUE
DATUM:  LDSPI R2; DB=7          "MASK FOR INDEX FIELD
        AND R2,R0               "LEAVE 3 BIT INDEX
        LDSPI R3; DB=VDATM-1      "SET BASE ADDRESS
        ADD R3,R0; SETMA        "ADD OFFSET, FETCH OLD DATUM VALUE
        MOV R0,R3;              "MD DATUM ADDRESS
          STATMA; MI<DPX(X1)      "STORE NEW DATUM
        ADD R2,R3; SETMA        "ADD 7, FETCH MSG ADDRESS
        LDSPI R4; DB=MD         "LOAD OLD DATUM VALUE
        ADD R2,R3; SETMA        "ADD 7, FETCH EXCHANGE ADDRESS
        MOV R4,R4               "FOR TESTING
        BNE DTM51;              "DO NOT SEND MSG
          IOFF;                   "INTERRUPTS OFF
          DPX(X0)<MD              "SAVE MSG ADDRESS FOR SEND
        SETMOD;                 "SET SUPVERVISOR MODE
          DPX(X1)<MD              "SAVE EXCHANGE ADDRESS
        JSR SEND                "SEND MSG
"
DTM51:  CLR R0;                 "TO RE-ENABLE HOST IRP
          RETURN                  "BACK TO SUPERVISOR
"
"
"
"/****** APXMT = GET VALUE FROM HOST INTERFACE = REL 0.0  , JUL 79 ************
"
"       REGISTER USAGE:
"         R0  DATA MANIPULATION
"         R1  RETURNS 16 BIT VALUE
"         R2  NOT USED
"         R3 R4 R5 R6 R7 ARE NOT CHANGED
"         X0  NOT USED
"         X1  16 BIT VALUE
"         X2  NOT USED
"         X3  NOT USED
"
"       ALGORITHM:
"       1.  WAIT FOR HOST TO WRITE SWR
"       2.  READ SWR
"       3.  PUT VALUE IN R1 & DPX(X1)
"       4.  RETURN
"
"
APXMT:  JSR WATSWR              "WAIT FOR HOST TO WRITE SWR
        SWDB;                   "READ SWR TO DB
          DPX(X1)<DB               "THEN TO DPX
        DB=DPX(X1);
          LDSPI R1;             "R1 GETS VALUE FROM SWR
          RETURN                   "SWR VALUE IN R1 & DPX(X1)
"
$END
